/* --------------------------------------------------------------
  StyleConfiguration.js 2019-06-07
  Gambio GmbH
  http://www.gambio.de
  Copyright (c) 2019 Gambio GmbH
  Released under the GNU General Public License (Version 2)
  [http://www.gnu.org/licenses/gpl-2.0.html]
  --------------------------------------------------------------*/


'use strict';

/**
 * Class StyleConfiguration
 */
export default class StyleConfiguration {
	/**
	 * Class Constructor
	 */
	constructor() {
		/**
		 * Name
		 *
		 * @type {String}
		 */
		this.name = null;
		
		/**
		 * Active Status
		 *
		 * @type {Boolean}
		 */
		this.active = null;
		
		/**
		 * Thumbnail Name
		 *
		 * @type {String}
		 */
		this.thumbnail = null;
		
		/**
		 * Boilerplate file name
		 *
		 * @type {String}
		 */
		this.boilerplate = null;
		
		/**
		 * Creation Date
		 *
		 * @type {Date}
		 */
		this.creationDate = null;
		
		/**
		 * Modification Date
		 *
		 * @type {Date}
		 */
		this.modificationDate = null;
		
		/**
		 * Boilerplate Modification Date
		 *
		 * @type {Date}
		 */
		this.boilerplateModificationDate = null;
		
		/**
		 * Color Palette
		 *
		 * @type {String[]}
		 */
		this.colorPalette = null;
		
		/**
		 * Settings
		 *
		 * @type {Collection}
		 */
		this.settings = null;
		
		/**
		 * Custom Styles
		 *
		 * @type {String}
		 */
		this.customStyles = null;
	}
	
	/**
	 * Name Getter
	 *
	 * @return {String}
	 */
	getName() {
		return this.name;
	}
	
	/**
	 * Name Setter
	 *
	 * @param {String} name
	 *
	 * @return {StyleConfiguration}
	 */
	setName(name) {
		StyleEdit.Validator.isString(name);
		this.name = name;
		return this;
	}
	
	/**
	 * Active Status Getter
	 *
	 * @return {Boolean}
	 */
	isActive() {
		return this.active;
	}
	
	/**
	 * Active Status Setter
	 *
	 * @param {Boolean} isActive
	 *
	 * @return {StyleConfiguration}
	 */
	setActive(isActive) {
		StyleEdit.Validator.isBool(isActive);
		this.active = isActive;
		return this;
	}
	
	/**
	 * Thumbnail Getter
	 *
	 * @return {String}
	 */
	getThumbnail() {
		return this.thumbnail;
	}
	
	/**
	 * Thumbnail Setter
	 *
	 * @param {String} thumbnail
	 *
	 * @return {StyleConfiguration}
	 */
	setThumbnail(thumbnail) {
		StyleEdit.Validator.isString(thumbnail);
		this.thumbnail = thumbnail;
		return this;
	}
	
	/**
	 * Boilerplate Getter
	 *
	 * @return {String}
	 */
	getBoilerplate() {
		return this.boilerplate;
	}
	
	/**
	 * Boilerplate Setter
	 *
	 * @param {String} boilerplate
	 *
	 * @return {StyleConfiguration}
	 */
	setBoilerplate(boilerplate) {
		StyleEdit.Validator.isString(boilerplate);
		this.boilerplate = boilerplate;
		return this;
	}
	
	/**
	 * Creation Date Getter
	 *
	 * @return {Date}
	 */
	getCreationDate() {
		return this.creationDate;
	}
	
	/**
	 * Creation Date Setter
	 *
	 * @param {Date} creationDate
	 *
	 * @return {StyleConfiguration}
	 */
	setCreationDate(creationDate) {
		StyleEdit.Validator.isObject(creationDate);
		this.creationDate = creationDate;
		return this;
	}
	
	/**
	 * Modification Date Getter
	 *
	 * @return {Date}
	 */
	getModificationDate() {
		return this.modificationDate;
	}
	
	/**
	 * Modification Date Setter
	 *
	 * @param {Date} modificationDate
	 *
	 * @return {StyleConfiguration}
	 */
	setModificationDate(modificationDate) {
		StyleEdit.Validator.isObject(modificationDate);
		this.modificationDate = modificationDate;
		return this;
	}
	
	/**
	 * Boilerplate Modification Date Getter
	 *
	 * @return {Date}
	 */
	getBoilerplateModificationDate() {
		return this.boilerplateModificationDate;
	}
	
	/**
	 * Boilerplate Modification Date Setter
	 *
	 * @param {Date} boilerplateModificationDate
	 *
	 * @return {StyleConfiguration}
	 */
	setBoilerplateModificationDate(boilerplateModificationDate) {
		StyleEdit.Validator.isObject(boilerplateModificationDate);
		this.boilerplateModificationDate = boilerplateModificationDate;
		return this;
	}
	
	/**
	 * Modification Date Getter
	 *
	 * @return {String[]}
	 */
	getColorPalette() {
		return this.colorPalette;
	}
	
	/**
	 * Modification Date Setter
	 *
	 * @param {String[]} colorPalette
	 *
	 * @return {StyleConfiguration}
	 */
	setColorPalette(colorPalette) {
		StyleEdit.Validator.isObject(colorPalette);
		this.colorPalette = colorPalette;
		return this;
	}
	
	/**
	 * Settings Getter
	 *
	 * @return {Collection}
	 */
	getSettings() {
		return this.settings;
	}
	
	/**
	 * Settings Setter
	 *
	 * @param {Collection} settings
	 *
	 * @return {StyleConfiguration}
	 */
	setSettings(settings) {
		StyleEdit.Validator.isObject(settings);
		this.settings = settings;
		return this;
	}
	
	/**
	 * Custom Styles Getter
	 *
	 * @return {String}
	 */
	getCustomStyles() {
		return this.customStyles;
	}
	
	/**
	 * Custom Styles Setter
	 *
	 * @param {String} customStyles
	 *
	 * @return {StyleConfiguration}
	 */
	setCustomStyles(customStyles) {
		StyleEdit.Validator.isString(customStyles);
		this.customStyles = customStyles;
		return this;
	}	
}
